/****************************************************************************/
/* LNK32.CMD - v2.203 COMMAND FILE FOR LINKING TMS470 32BIS C/C++ PROGRAMS  */
/*                                                                          */
/*   Usage:  lnk470 <obj files...>    -o <out file> -m <map file> lnk32.cmd */
/*           cl470 <src files...> -z -o <out file> -m <map file> lnk32.cmd  */
/*                                                                          */
/*   Description: This file is a sample command file that can be used       */
/*                for linking programs built with the TMS470 C/C++          */
/*                Compiler.   Use it as a guideline; you may want to change */
/*                the allocation scheme according to the size of your       */
/*                program and the memory layout of your target system.      */
/*                                                                          */
/*   Notes: (1)   You must specify the directory in which run-time support  */
/*                library is located.  Either add a "-i<directory>" line to */
/*                this file, or use the system environment variable C_DIR   */
/*                to specify a search path for libraries.                   */
/*                                                                          */
/*          (2)   If the run-time support library you are using is not      */
/*                named below, be sure to use the correct name here.        */
/*                                                                          */
/****************************************************************************/
-e _reset  				   /* entry-point = _reset */
-c                                         /* LINK USING C CONVENTIONS      */
-stack  0x20000                             /* SOFTWARE STACK SIZE           */
-heap   0xA00000                           /* HEAP AREA SIZE                */
-l rts32e.lib                               /* GET RUN-TIME SUPPORT         */

/* SPECIFY THE SYSTEM MEMORY MAP */

MEMORY
{
    P_SDRAM  : org = 0x00000000   len = 0x01000000		/* 16MB SDRAM       */
    SHARE_MEN: org = 0x11200000   len = 0x00100000      /*  1MB SDRAM       */
    INPUT_MEM: org = 0x11300000   len = 0x00B00000      /* 11MB SDRAM       */
    FRAMEBUFF: org = 0x11E00000   len = 0x00025820      /* 32 + 2*320*240 byte */
    SRAM     : org = 0x20000000   len = 0x0003E800      /* 250KB SRAM       */
    SARAM    : org = 0xE0010000   len = 0x00018000      /* 96KB SARAM       */
    
}

/* SPECIFY THE SECTIONS ALLOCATION INTO MEMORY */

SECTIONS
{
    .intvecs : {} > 0x0                  /* INTERRUPT VECTORS                 */
    .bss     : {} > P_SDRAM              /* GLOBAL & STATIC VARS              */
    .sysmem  : {} > P_SDRAM              /* DYNAMIC MEMORY ALLOCATION AREA    */
    .stack   : {} > P_SDRAM              /* SOFTWARE SYSTEM STACK             */
    .svcStack: {} > P_SDRAM      
    .text    : {} > P_SDRAM              /* CODE                              */
    .cinit   : {} > P_SDRAM              /* INITIALIZATION TABLES             */
    .const   : {} > P_SDRAM              /* CONSTANT DATA                     */
    .pinit   : {} > P_SDRAM              /* TEMPLATE INSTANTIATION TABLES     */
}
